﻿using System.Collections;
using System.Collections.Generic;
using Unity.XR.Qiyu;
using UnityEngine;
using UnityEngine.UI;

public class SeethroughTest : MonoBehaviour
{
    public GameObject ground;
    public Text switchButtonText;

    // Start is called before the first frame update
    void Start()
    {
        switchButtonText.text = string.Format("Seethrough({0})",
    QiyuManager.Instance.passthroughAsBackground ? "on" : "off");
        //set seethrough callback
        QiyuXRCore.RegisterSeeThroughCallback(OnSeeThroughChanged);
    }

    private void OnDestroy()
    {
        QiyuXRCore.UnRegisterSeeThroughCallback(OnSeeThroughChanged);
    }

    void OnSeeThroughChanged(int state)
    {
        Debug.LogFormat("SeeThrough state changed:{0}", state);

        if (ground)
        {
            ground.SetActive(state == SeeThroughChangeStatus.AppOpen ? false : true);
        }
    }

    public void OnButtonClick(GameObject btn)
    {
        if (btn.name == "Seethrough")
        {
            QiyuManager.Instance.passthroughAsBackground = !QiyuManager.Instance.passthroughAsBackground;
            switchButtonText.text = string.Format("Seethrough({0})",
                QiyuManager.Instance.passthroughAsBackground ? "on" : "off");
            QiyuSeeThrough.EnableSeeThrough(QiyuManager.Instance.passthroughAsBackground);
        }
    }
}
